#!/bin/bash

for x in 0.5 0.6 0.7 0.8 0.9; do

mkdir $x
cd $x

c=$x
f=$(awk "BEGIN {print ($x)+0.05}")
echo $f


cat > scf.in << EOF
&control
 calculation = 'scf'
 prefix='mgo',
 pseudo_dir = './',
 outdir='./'
 wf_collect=.true.
 verbosity='high'
    tefield = .true.
    dipfield =.true.
    nstep = 300
/
&SYSTEM
  ibrav = 0
  A =    4.21700
  nat = 24
  ntyp = 2
 ecutwfc = 100.0,
 occupations = 'smearing'
 smearing = 'm-p'
 degauss = 0.001
 eamp        = 0.00
 edir        = 3
 emaxpos     = $c
 eopreg      = 0.05
/
&ELECTRONS
 conv_thr=1e-12
/
&IONS
/
CELL_PARAMETERS {alat}
  1.000000000000000   0.000000000000000   0.000000000000000 
  0.000000000000000   1.000000000000000   0.000000000000000 
  0.000000000000000   0.000000000000000   6.000000000000000 
ATOMIC_SPECIES
  Mg   24.30500  Mg_ONCV_PBE-1.0.upf
   O   15.99900  O_ONCV_PBE-1.0.upf
ATOMIC_POSITIONS (crystal)
Mg       0.000000000   0.000000000   0.000000000    0   0   0
O        0.500000000   0.000000000   0.000000000    0   0   0
O        0.000000000   0.500000000   0.000000000    0   0   0
Mg       0.500000000   0.500000000   0.000000000    0   0   0
O        0.000000000  -0.000000000   0.083682305
Mg       0.500000000  -0.000000000   0.083722295
Mg       0.000000000   0.500000000   0.083722295
O        0.500000000   0.500000000   0.083682305
Mg       0.000000000  -0.000000000   0.167829891
O        0.500000000  -0.000000000   0.167875093
O        0.000000000   0.500000000   0.167875093
Mg       0.500000000   0.500000000   0.167829891
O        0.000000000   0.000000000   0.252649362
Mg       0.500000000   0.000000000   0.252815453
Mg      -0.000000000   0.500000000   0.252815452
O        0.500000000   0.500000000   0.252649361
Mg       0.000000000   0.000000000   0.337913171
O        0.500000000   0.000000000   0.337773598
O        0.000000000   0.500000000   0.337773598
Mg       0.500000000   0.500000000   0.337913171
O        0.000000000   0.000000000   0.423516982
Mg       0.500000000   0.000000000   0.421614758
Mg       0.000000000   0.500000000   0.421614758
O        0.500000000   0.500000000   0.423516983
K_POINTS automatic
 3 3 1 0 0 0
EOF

cat > pp.in << EOF
&INPUTPP
    prefix='mgo',
    outdir='./' 
    filplot='pot.dat'
    plot_num =11
/
EOF

cat > average.in << EOF
1
pot.dat
1.0
300
3
3.00000
EOF

path="/opt/qe-6.2.1-devel/bin"

mpiexec -np 6 $path/pw.x -nk 1 <scf.in >& scf.out
$path/pp.x <pp.in
$path/average.x <average.in


cd ..

done

