#!/bin/bash

rm *.wfc*
rm *.out
rm *.rap 
rm *.proj
rm *.lowdin
rm *.in 
rm *.all
rm *.ps
rm *.gnu
rm -r ag.save


path=../pseudo


for pseudo in 'ag_pbe_v1.4.uspp.F.UPF' 'Ag.pbe-n-kjpaw_psl.1.0.0.UPF' 'Ag_ONCV_PBE-Chris.UPF' ; do

mkdir $pseudo
cd $pseudo

cat >scf.in <<EOF
&control
 calculation = 'scf'
 prefix='ag',
 pseudo_dir = '$path'
 outdir='./'
 wf_collect=.true.
 verbosity='high'
/
&SYSTEM
 ibrav = 2
 celldm(1) = 7.843266062 !from VC relax
 nat = 1
 ntyp = 1
 ecutwfc = 100
 ecutrho = 500.0,
 occupations = 'smearing'
 smearing = 'm-p'
 degauss = 0.001
/
&ELECTRONS
 conv_thr=1e-12
/
ATOMIC_SPECIES
  Ag  107.86820  $pseudo
ATOMIC_POSITIONS {crystal}
Ag   0.000000000000000   0.000000000000000   0.000000000000000  
K_POINTS automatic
12 12 12 0 0 0
EOF

cat >bands.in <<EOF
&control
 calculation = 'bands'
 prefix='ag',
 pseudo_dir = $path,
 outdir='./'
 wf_collect=.true.
 verbosity='high'
/
&SYSTEM
 ibrav = 2
 celldm(1) = 7.843266062 !from VC relax
 nat = 1
 ntyp = 1
 ecutwfc = 100
 ecutrho = 500.0,
 occupations = 'smearing'
 smearing = 'm-p'
 degauss = 0.001
 nbnd=20
/
&ELECTRONS
 conv_thr=1e-9
 conv_thr_init=1e-3
 diagonalization='cg'
/
ATOMIC_SPECIES
  Ag  107.86820  $pseudo
ATOMIC_POSITIONS {crystal}
Ag   0.000000000000000   0.000000000000000   0.000000000000000  
K_POINTS crystal_b
5
   0.0000000000     0.0000000000     0.0000000000  100 !   GAMMA
   0.5000000000     0.0000000000     0.0000000000  100 !   L
   0.7500000000     0.2500000000     0.5000000000  100 !   W
   0.5000000000     0.0000000000     0.5000000000  100 !   X
   0.0000000000     0.0000000000     0.0000000000  100 !   GAMMA


EOF

cat >band.in <<EOF
&bands
    prefix = 'ag',
    outdir = './',
    lsym=.true.
/
EOF

cat >proj.in <<EOF
&PROJWFC
 prefix='ag'
 outdir='./'
 filproj='proj'
 lsym=.false.
/
EOF


mpirun -np 6 /opt/qe-6.3/bin/pw.x <scf.in >scf.out
mpirun -np 6 /opt/qe-6.3/bin/pw.x <bands.in >bands_.out
mpirun -np 6 /opt/qe-6.3/bin/bands.x <band.in >band_.out
mpirun -np 6 /opt/qe-6.3/bin/projwfc.x <proj.in >proj.out

mv proj.projwfc_up bands.out.proj

s=$(grep "state #" proj.out |grep "(l=0" |awk '{print $3+0}' | tr '\n' ' ')
p=$(grep "state #" proj.out |grep "(l=1" |awk '{print $3+0}' | tr '\n' ' ')
d=$(grep "state #" proj.out |grep "(l=2" |awk '{print $3+0}' | tr '\n' ' ')

cat >plotband.in <<EOF
bands.out
 $s
 -50.0 50.0
bands_s.dat.gnu
bands_s.ps
 0
 2.0  0
EOF

plotband.x <plotband.in


for filgnu in bands_s.dat.gnu.[0-9].[0-9];
do
    cat $filgnu >> bands_s.dat.all
    echo "\n" >> bands_s.dat.all
done

rm bands_s.dat.gnu.*

cat >plotband.in <<EOF
bands.out
 $d
 -50.0 50.0
bands_d.dat.gnu
bands_d.ps
 0
 2.0  0
EOF

plotband.x <plotband.in


for filgnu in bands_d.dat.gnu.[0-9].[0-9];
do
    cat $filgnu >> bands_d.dat.all
    echo "\n" >> bands_d.dat.all
done

rm bands_d.dat.gnu.*

cat >plotband.in <<EOF
bands.out
 $p
 -50.0 50.0
bands_p.dat.gnu
bands_p.ps
 0
 2.0  0
EOF

plotband.x <plotband.in


for filgnu in bands_p.dat.gnu.[0-9].[0-9];
do
    cat $filgnu >> bands_p.dat.all
    echo "\n" >> bands_p.dat.all
done

rm bands_p.dat.gnu.*


rm -r ag.save
rm *.wfc

Ef=$(cat scf.out |grep Fermi |awk '{print $5}')

cat >plot.gnu <<EOF
set terminal pdf enhanced size 8cm,12cm
set output "bands_$pseudo.pdf"


set ylabel "E_{KS} (eV)"

set title "Ag (bulk)"

Ef=$Ef

ymin=-5
ymax=5

set yrange [ymin:ymax]
set xrange [0:3.0731]
set xtics ("{/Symbol G}" 0.000, "L" 0.8660, "W" 1.5731, "X" 2.0731, "{/Symbol G}" 3.0731)

set arrow from 0.8660, ymin to 0.8660, ymax nohead
set arrow from 1.5731, ymin to 1.5731, ymax nohead
set arrow from 2.0731, ymin to 2.0731, ymax nohead

set title "Fatbands of Ag"
plot  "bands.out.gnu" u 1:($2-Ef) w l lt -1 notitle,\
      "bands_d.dat.all" u 1:($2-Ef):3 w points lt 3 pt 7 ps variable notitle ,\
      "bands_s.dat.all" u 1:($2-Ef):3 w points lt 4 pt 7 ps variable notitle ,\
      "bands_p.dat.all" u 1:($2-Ef):3 w points lt 2  pt 7 ps variable  notitle ,\
       1/0 w l lt 2 title "Ag:p",1/0 w l lt 3 title "Ag:d",1/0 w l lt 4 title "Ag:s",\
       Ef w l lt -1 dt 2 notitle


EOF

gnuplot plot.gnu

cd ..

done

