#!/bin/bash

rm *.wfc*
rm *.all

cat >scf.in <<EOF
&control
 calculation = 'scf'
 prefix='ag',
 pseudo_dir = '/home/chris/Work/QE/PP/ONCV-custom',
 outdir='./'
 wf_collect=.true.
 verbosity='high'
/
&SYSTEM
 ibrav = 2
 celldm(1) = 7.843266062 !from VC relax
 nat = 1
 ntyp = 1
 ecutwfc = 100,
 !ecutrho = 800.0,
 occupations = 'smearing'
 smearing = 'm-p'
 degauss = 0.001
/
&ELECTRONS
 conv_thr=1e-12
/
ATOMIC_SPECIES
  Ag  107.86820  Ag_ONCV_PBE-Chris.UPF
ATOMIC_POSITIONS {crystal}
Ag   0.000000000000000   0.000000000000000   0.000000000000000  
K_POINTS automatic
12 12 12 0 0 0
EOF

cat >bands.in <<EOF
&control
 calculation = 'bands'
 prefix='ag',
 pseudo_dir = '/home/chris/Work/QE/PP/ONCV-custom',
 outdir='./'
 wf_collect=.true.
 verbosity='high'
/
&SYSTEM
 ibrav = 2
 celldm(1) = 7.843266062 !from VC relax
 nat = 1
 ntyp = 1
 ecutwfc = 100,
 !ecutrho = 800.0,
 occupations = 'smearing'
 smearing = 'm-p'
 degauss = 0.001
 nbnd=20
/
&ELECTRONS
 conv_thr=1e-9
 conv_thr_init=1e-3
 diagonalization='cg'
/
ATOMIC_SPECIES
  Ag  107.86820  Ag_ONCV_PBE-Chris.UPF
ATOMIC_POSITIONS {crystal}
Ag   0.000000000000000   0.000000000000000   0.000000000000000  
K_POINTS crystal_b
5
   0.0000000000     0.0000000000     0.0000000000  100 !   GAMMA
   0.5000000000     0.0000000000     0.0000000000  100 !   L
   0.7500000000     0.2500000000     0.5000000000  100 !   W
   0.5000000000     0.0000000000     0.5000000000  100 !   X
   0.0000000000     0.0000000000     0.0000000000  100 !   GAMMA


EOF

cat >band.in <<EOF
&bands
    prefix = 'ag',
    outdir = './',
    lsym=.true.
/
EOF

cat >proj.in <<EOF
&PROJWFC
 prefix='ag'
 outdir='./'
 filproj='proj'
 lsym=.false.
/
EOF


mpirun -np 6 /opt/qe-6.3/bin/pw.x <scf.in >scf.out
mpirun -np 6 /opt/qe-6.3/bin/pw.x <bands.in >bands.out
mpirun -np 6 /opt/qe-6.3/bin/bands.x <band.in >band.out
mpirun -np 6 /opt/qe-6.3/bin/projwfc.x <proj.in >proj.out

mv proj.projwfc_up bands.out.proj

cat >plotband.in <<EOF
bands.out
 1 5
 -50.0 50.0
bands_s.dat.gnu
bands_s.ps
 0
 2.0  0
EOF

plotband.x <plotband.in


for filgnu in bands_s.dat.gnu.[0-9].[0-9];
do
    cat $filgnu >> bands_s.dat.all
    echo "\n" >> bands_s.dat.all
done

rm bands_s.dat.gnu.*

cat >plotband.in <<EOF
bands.out
 6 7 8 9 10
 -50.0 50.0
bands_d.dat.gnu
bands_d.ps
 0
 2.0  0
EOF

plotband.x <plotband.in


for filgnu in bands_d.dat.gnu.[0-9].[0-9];
do
    cat $filgnu >> bands_d.dat.all
    echo "\n" >> bands_d.dat.all
done

rm bands_d.dat.gnu.*

cat >plotband.in <<EOF
bands.out
 2 3 4
 -50.0 50.0
bands_p.dat.gnu
bands_p.ps
 0
 2.0  0
EOF

plotband.x <plotband.in


for filgnu in bands_p.dat.gnu.[0-9].[0-9];
do
    cat $filgnu >> bands_p.dat.all
    echo "\n" >> bands_p.dat.all
done

rm bands_p.dat.gnu.*

gnuplot plot.gnuscf

rm -r ag.save
rm *.wfc


