#!/bin/bash


cat >scf.in <<EOF
 &control
    calculation='scf',
    prefix='pb',
    pseudo_dir = './',
    outdir='./',
    tprnfor = .true.,
    tstress = .true.,
    wf_collect = .true.
 /
 &system
    noncolin  = .true.,
    lspinorb  = .true.,
    ibrav = 2,
    celldm(1) = 9.269771512,
    nat=  1 ,
    ntyp = 1 ,
    ecutwfc = 90,
    occupations = 'smearing',
    degauss = 0.01
 /
 &electrons
    mixing_beta = 0.7,
    conv_thr =  1.0d-12
 /
ATOMIC_SPECIES
 Pb 207.2   Pb_ONCV_PBE_fr.upf
ATOMIC_POSITIONS crystal
Pb        0.000000000   0.000000000   0.000000000
K_POINTS AUTOMATIC
8 8 8 1 1 1
EOF

cat >bands.in <<EOF
 &control
    calculation='bands',
    prefix='pb',
    pseudo_dir = './',
    outdir='./',
    verbosity = 'high'
    wf_collect = .true.
 /
 &system
    noncolin  = .true.,
    lspinorb  = .true.,
    ibrav = 2,
    celldm(1) = 9.269771512,
    nat=  1 ,
    ntyp = 1 ,
    ecutwfc = 90,
    occupations = 'smearing',
    degauss = 0.01
    nbnd    = 30
 /
 &electrons
    mixing_beta = 0.7,
    conv_thr =  1.0d-8
   diago_full_acc = .true.
 /
ATOMIC_SPECIES
 Pb 207.2   Pb_ONCV_PBE_fr.upf
ATOMIC_POSITIONS crystal
Pb        0.000000000   0.000000000   0.000000000
K_POINTS crystal_b
5
   0.0000000000     0.0000000000     0.0000000000  21 !   GAMMA
   0.5000000000     0.0000000000     0.0000000000  21 !   L
   0.7500000000     0.2500000000     0.5000000000  21 !   W
   0.5000000000     0.0000000000     0.5000000000  21 !   X
   0.0000000000     0.0000000000     0.0000000000  21 !   GAMMA
EOF

cat >band.in <<EOF
&bands
    prefix = 'pb',
    outdir = './',
    lsym=.true.
/
EOF

cat >proj.in <<EOF
&PROJWFC
 prefix='pb'
 outdir='./'
 filproj='proj'
 lsym=.false.
/
EOF


mpirun -np 6 pw.x <scf.in >scf.out
mpirun -np 6 pw.x <bands.in >bands_.out
mpirun -np 6 bands.x <band.in >band_.out
mpirun -np 6 projwfc.x <proj.in >proj.out


cat >fatbands.py<<EOF
#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
@author: yyyu200@163.com
"""

import numpy as np

# plot range for y-axis
ymin=-20
ymax=12
dline=21 # vertical line intervals
lw=0.5 # line width
nband=14 # highest valence band
Ef=12.8267 # Fermi energy
feig=open('bands.out')
l=feig.readline()
nbnd=int(l.split(',')[0].split('=')[1])
nks=int(l.split(',')[1].split('=')[1].split('/')[0])
print("there are %i kpoints and %i bands" %(nks, nbnd))
eig=np.zeros((nks,nbnd),dtype=float)
for i in range(nks):
    l=feig.readline()
    count=0
    if nbnd%10==0:
        n=nbnd//10
    else:
        n=nbnd//10+1
    for j in range(n):
        l=feig.readline()
        for k in range(len(l.split())):
            eig[i][count]=l.split()[k]
            count=count+1

feig.close()

import matplotlib as mpl
mpl.use('Agg')
import matplotlib.pyplot as plt

F=plt.gcf()
F.set_size_inches([4,4])
p1=plt.subplot(1, 1, 1)

#eig_vbm=max(eig[:, nband-1])
eig_vbm=Ef
print(eig_vbm)
#eig_vbm= 0.00 # fermi energy level in scf output for metals
for i in range(nbnd):
    line1=plt.plot(np.arange(0,nks), eig[:,i]-eig_vbm,color='grey',linewidth=lw )

vline=dline
while vline<nks-1:
    plt.axvline(x=vline, ymin=ymin, ymax=ymax,linewidth=lw,color='black')
    vline=vline+dline

elem=['Pb']
ielem=np.array([1],dtype=np.int32) # number of atoms for each element
orb=[['d','s','p']]  # projectors for each element

N=len(elem)
iorb=np.zeros([N],dtype=np.int32)  # number of projectors for each element
for i in range(N):
    iorb[i]=len(orb[i])

print("there are %i elements and %i orbitals" %(len(elem), iorb))
print(orb)
lorb=np.zeros([N,],dtype=np.int32) # number of local orbital for each element
for i in range(N):
    for k, j in enumerate(orb[i]):
        if j is 's':
            lorb[i]+=1*2
            print("orbital %s is s type with a position of %i" %(k,lorb[i]))
        elif j is 'p':
            lorb[i]+=3*2
            print("orbital %s is p type with a position of %i" %(k,lorb[i]))
        elif j is 'd':
            lorb[i]+=5*2
            print("orbital %s is d type with a position of %i" %(k,lorb[i]))
        elif j is 'f':
            lorb[i]+=7*2
            print("orbital %s is f type with a position of %i" %(k,lorb[i]))
        else:
            print("unexpected orbital type: " %k)
            assert False


nlorb=np.dot(ielem,lorb)
print("there are %i orbital moments in total" %nlorb)
pjsum=np.zeros([nlorb, nks, nbnd], dtype=np.float32)

filproj=open('proj.projwfc_up')
nline_io_header=4 # line number at '    F    F'

for i in range(nline_io_header):
    filproj.readline()
    print(filproj.readline())

for i in range(nlorb):
    filproj.readline()
    #print(float(filproj.readline().split()[2]))
    for j in range(nks):
        for k in range(nbnd):
            pjsum[i,j,k]=float(filproj.readline().split()[2])

nplotline=np.sum(iorb)
# oo, orbital index for each kind of color, oo can be generated by the following commands
#grep '[a-zA-Z]' proj.projwfc_up |grep 2P|awk '{printf( $1-1",")}'
#oo=[[0,9], [10,11],[12,17]]
oo=[[0,9]]
s_of_o=np.zeros([nks,],dtype=np.float32)
color=['r','g','orange','cyan','blue']
label=['Pb d','Pb s','Pb p']

scale=90.0
st=[]
for i in range(len(oo)):
    for k in range(nbnd):
        s_of_o=np.zeros([nks,],dtype=np.float32)
        for j in oo[i]:
            s_of_o[:]+=pjsum[j,:,k]
        if k == 0:
            st.append(plt.scatter(-1, ymin-1, 20, c=color[i], alpha=0.5, label=label[i],marker='.',edgecolor='none'))
        st.append(plt.scatter(np.arange(0,nks), eig[:,k]-eig_vbm, s=scale*s_of_o, c=color[i], alpha=0.5, marker='.',edgecolor='none'))

plt.hlines(0,0,nks-1, color='k', linestyles='dashed',linewidths=0.5)
plt.xlim([0,nks-1]) # 201 points
plt.ylim([ymin,ymax])
plt.ylabel(r'E (eV)',fontsize=16)
plt.xticks((0,21,42,63,85), ( r'\${\Gamma}\$', 'L', 'W', 'X' ,r'\${\Gamma}\$') )

plt.subplots_adjust(left=0.20, right=0.75, top=0.95, bottom=0.1)
p1.legend(scatterpoints =1, numpoints=1,markerscale=2.0, bbox_to_anchor=(0, 1), loc='upper left', borderaxespad=0.2)

plt.savefig('pjband.png',dpi=400)

EOF

python3.7 fatbands.py



